/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import org.fife.ui.rsyntaxtextarea.DocumentRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchResult
implements Comparable<SearchResult> {
    private DocumentRange matchRange;
    private int count;
    private int markedCount;

    public SearchResult() {
        this(null, 0, 0);
    }

    public SearchResult(DocumentRange range2, int count2, int markedCount) {
        this.matchRange = range2;
        this.count = count2;
        this.markedCount = markedCount;
    }

    @Override
    public int compareTo(SearchResult other) {
        if (other == null) {
            return 1;
        }
        if (other == this) {
            return 0;
        }
        int diff2 = this.count - other.count;
        if (diff2 != 0) {
            return diff2;
        }
        diff2 = this.markedCount - other.markedCount;
        if (diff2 != 0) {
            return diff2;
        }
        if (this.matchRange == null) {
            return other.matchRange == null ? 0 : -1;
        }
        return this.matchRange.compareTo(other.matchRange);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof SearchResult) {
            return this.compareTo((SearchResult)other) == 0;
        }
        return false;
    }

    public int getCount() {
        return this.count;
    }

    public int getMarkedCount() {
        return this.markedCount;
    }

    public DocumentRange getMatchRange() {
        return this.matchRange;
    }

    public int hashCode() {
        int hash = this.count + this.markedCount;
        if (this.matchRange != null) {
            hash += this.matchRange.hashCode();
        }
        return hash;
    }

    public void setCount(int count2) {
        this.count = count2;
    }

    public void setMarkedCount(int markedCount) {
        this.markedCount = markedCount;
    }

    public void setMatchRange(DocumentRange range2) {
        this.matchRange = range2;
    }

    public String toString() {
        return "[SearchResult: count=" + this.getCount() + ", markedCount=" + this.getMarkedCount() + ", matchRange=" + this.getMatchRange() + "]";
    }

    public boolean wasFound() {
        return this.getCount() > 0;
    }
}

